# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SupabaseTable(UniversalBaseModel):
    """
    Supabase Table object
    """

    name: str = pydantic.Field()
    """
    Table name
    """

    columns: typing.Dict[str, str] = pydantic.Field()
    """
    Table schema mapping column names to types
    """

    rows: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(default=None)
    """
    Table data rows
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
