# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .supabase_table import SupabaseTable


class SupabaseProject(UniversalBaseModel):
    """
    Supabase Project object
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project ID (read-only, set by Supabase)
    """

    name: str = pydantic.Field()
    """
    Project name
    """

    tables: typing.Optional[typing.List[SupabaseTable]] = pydantic.Field(default=None)
    """
    List of tables in the project
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
