# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .snowflake_column import SnowflakeColumn
from .snowflake_row import SnowflakeRow


class SnowflakeTable(UniversalBaseModel):
    """
    Snowflake Table object
    """

    name: str = pydantic.Field()
    """
    Table name
    """

    columns: typing.List[SnowflakeColumn] = pydantic.Field()
    """
    List of columns in the table
    """

    rows: typing.Optional[typing.List[SnowflakeRow]] = pydantic.Field(default=None)
    """
    Initial data rows for the table
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
