# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .snowflake_table import SnowflakeTable


class SnowflakeSchema(UniversalBaseModel):
    """
    Snowflake Schema object (namespace within a database)
    """

    name: str = pydantic.Field()
    """
    Schema name, cannot be 'PUBLIC' since it's a default schema
    """

    tables: typing.Optional[typing.List[SnowflakeTable]] = pydantic.Field(default=None)
    """
    Tables in this schema
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
