# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .snowflake_schema import SnowflakeSchema


class SnowflakeDatabase(UniversalBaseModel):
    """
    Snowflake Database object
    """

    name: str = pydantic.Field()
    """
    Database name, cannot be 'SNOWFLAKE' or 'USER$...' since they are default databases
    """

    comment: typing.Optional[str] = pydantic.Field(default=None)
    """
    Database comment/description
    """

    schemas: typing.Optional[typing.List[SnowflakeSchema]] = pydantic.Field(default=None)
    """
    Schemas in this database
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
