# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SnowflakeColumn(UniversalBaseModel):
    """
    Snowflake Table Column definition
    """

    name: str = pydantic.Field()
    """
    Column name
    """

    data_type: str = pydantic.Field()
    """
    Column data type (e.g., VARCHAR, NUMBER, TIMESTAMP)
    """

    nullable: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the column can be NULL
    """

    default: typing.Optional[str] = pydantic.Field(default=None)
    """
    Default value for the column
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
