# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs


class SlackChannel(UniversalBaseModel):
    """
    Slack Channel (Conversation) object
    """

    name: str = pydantic.Field()
    """
    Channel name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Channel description/purpose
    """

    is_private: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the channel is private
    """

    messages: typing.Optional[typing.List["SlackMessage"]] = pydantic.Field(default=None)
    """
    Messages in this channel
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .slack_message import SlackMessage  # noqa: E402, I001

update_forward_refs(SlackChannel)
