# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ShopifyProductVariant(UniversalBaseModel):
    """
    Product variant within a Shopify product

    Attributes:
        price: Product variant price
        sku: Stock Keeping Unit identifier
        inventory_quantity: Available inventory count
    """

    price: str = pydantic.Field()
    """
    Product variant price (e.g., '29.99')
    """

    sku: str = pydantic.Field()
    """
    Stock Keeping Unit identifier
    """

    inventory_quantity: int = pydantic.Field()
    """
    Available inventory count
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
