# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .shopify_product_variant import ShopifyProductVariant


class ShopifyProduct(UniversalBaseModel):
    """
    Shopify product data

    Attributes:
        title: Product title/name
        body_html: HTML description of the product
        vendor: Product vendor/brand name
        product_type: Category/type of product
        status: Product status (active, draft, archived)
        variants: List of product variants (at least one required)
    """

    title: str = pydantic.Field()
    """
    Product title/name
    """

    body_html: typing.Optional[str] = pydantic.Field(default=None)
    """
    HTML description of the product
    """

    vendor: str = pydantic.Field()
    """
    Product vendor/brand name
    """

    product_type: str = pydantic.Field()
    """
    Category/type of product
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    Product status (active, draft, archived)
    """

    variants: typing.List[ShopifyProductVariant] = pydantic.Field()
    """
    List of product variants
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
