# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .shopify_customer import ShopifyCustomer
from .shopify_product import ShopifyProduct


class ShopifyData(UniversalBaseModel):
    """
    Complete Shopify sandbox data structure

    Note: Orders are created automatically by the sandbox based on products and customers.
    The initialize method will generate orders that link customers to products.
    """

    products: typing.Optional[typing.List[ShopifyProduct]] = pydantic.Field(default=None)
    """
    List of products to create
    """

    customers: typing.Optional[typing.List[ShopifyCustomer]] = pydantic.Field(default=None)
    """
    List of customers to create
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
