# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .shopify_address import ShopifyAddress


class ShopifyCustomer(UniversalBaseModel):
    """
    Shopify customer data

    Attributes:
        email: Customer email address (optional - may not be present in API response)
        first_name: Customer first name (optional - may not be present in API response)
        last_name: Customer last name (optional - may not be present in API response)
        addresses: List of customer addresses
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Customer email address
    """

    first_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Customer first name
    """

    last_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Customer last name
    """

    addresses: typing.Optional[typing.List[ShopifyAddress]] = pydantic.Field(default=None)
    """
    List of customer addresses
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
