# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ShopifyAddress(UniversalBaseModel):
    """
    Customer address information

    Attributes:
        address1: Street address line 1 (optional - may not be present in API response)
        city: City name (optional - may not be present in API response)
        province: State/province code (optional - may not be present in API response)
        zip: Postal/ZIP code (optional - may not be present in API response)
        country: Country code (e.g., 'US') (optional - may not be present in API response)
    """

    address1: typing.Optional[str] = pydantic.Field(default=None)
    """
    Street address line 1
    """

    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    City name
    """

    province: typing.Optional[str] = pydantic.Field(default=None)
    """
    State/province code
    """

    zip: typing.Optional[str] = pydantic.Field(default=None)
    """
    Postal/ZIP code
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    Country code (e.g., 'US')
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
