# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .sandbox_mcp_server import SandboxMcpServer
from .sandbox_status import SandboxStatus


class SandboxInfo(UniversalBaseModel):
    """
    Detailed information about a sandbox
    """

    sandbox_id: str = pydantic.Field()
    """
    Unique identifier for the sandbox
    """

    server_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL to connect to the MCP server
    """

    server_name: SandboxMcpServer = pydantic.Field()
    """
    The MCP server type
    """

    status: SandboxStatus = pydantic.Field()
    """
    Current status of the sandbox
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Last update timestamp
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
