# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class SalesforceOpportunity(UniversalBaseModel):
    """
    Salesforce Opportunity object with comprehensive field support
    """

    name: typing_extensions.Annotated[str, FieldMetadata(alias="Name")] = pydantic.Field()
    """
    Opportunity name (required)
    """

    stage_name: typing_extensions.Annotated[str, FieldMetadata(alias="StageName")] = pydantic.Field()
    """
    Sales stage (required, e.g., Prospecting, Qualification, Closed Won)
    """

    close_date: typing_extensions.Annotated[str, FieldMetadata(alias="CloseDate")] = pydantic.Field()
    """
    Close date (required, format: YYYY-MM-DD)
    """

    amount: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="Amount")] = pydantic.Field(
        default=None
    )
    """
    Opportunity amount
    """

    probability: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="Probability")] = pydantic.Field(
        default=None
    )
    """
    Probability of closing (0-100)
    """

    account_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="AccountId")] = pydantic.Field(
        default=None
    )
    """
    Related account ID (18-char Salesforce ID)
    """

    type: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Type")] = pydantic.Field(default=None)
    """
    Opportunity type (e.g., New Business, Existing Business)
    """

    lead_source: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="LeadSource")] = pydantic.Field(
        default=None
    )
    """
    Lead source (e.g., Web, Phone Inquiry, Partner Referral)
    """

    next_step: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="NextStep")] = pydantic.Field(
        default=None
    )
    """
    Next step in the sales process
    """

    description: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Description")] = pydantic.Field(
        default=None
    )
    """
    Opportunity description
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
