# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class SalesforceLead(UniversalBaseModel):
    """
    Salesforce Lead object with comprehensive field support
    """

    first_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="FirstName")] = pydantic.Field(
        default=None
    )
    """
    First name
    """

    last_name: typing_extensions.Annotated[str, FieldMetadata(alias="LastName")] = pydantic.Field()
    """
    Last name (required)
    """

    company: typing_extensions.Annotated[str, FieldMetadata(alias="Company")] = pydantic.Field()
    """
    Company name (required)
    """

    email: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Email")] = pydantic.Field(
        default=None
    )
    """
    Email address
    """

    phone: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Phone")] = pydantic.Field(
        default=None
    )
    """
    Phone number
    """

    mobile_phone: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="MobilePhone")] = (
        pydantic.Field(default=None)
    )
    """
    Mobile phone number
    """

    title: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Title")] = pydantic.Field(
        default=None
    )
    """
    Job title
    """

    status: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Status")] = pydantic.Field(
        default=None
    )
    """
    Lead status (e.g., Open, Contacted, Qualified)
    """

    lead_source: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="LeadSource")] = pydantic.Field(
        default=None
    )
    """
    Lead source (e.g., Web, Phone Inquiry, Partner Referral)
    """

    industry: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Industry")] = pydantic.Field(
        default=None
    )
    """
    Industry (e.g., Technology, Healthcare, Finance)
    """

    rating: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Rating")] = pydantic.Field(
        default=None
    )
    """
    Lead rating (e.g., Hot, Warm, Cold)
    """

    street: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Street")] = pydantic.Field(
        default=None
    )
    """
    Street address
    """

    city: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="City")] = pydantic.Field(default=None)
    """
    City
    """

    state: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="State")] = pydantic.Field(
        default=None
    )
    """
    State/province
    """

    postal_code: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="PostalCode")] = pydantic.Field(
        default=None
    )
    """
    Postal code
    """

    country: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Country")] = pydantic.Field(
        default=None
    )
    """
    Country
    """

    website: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Website")] = pydantic.Field(
        default=None
    )
    """
    Website URL
    """

    description: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Description")] = pydantic.Field(
        default=None
    )
    """
    Lead description
    """

    number_of_employees: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="NumberOfEmployees")] = (
        pydantic.Field(default=None)
    )
    """
    Number of employees
    """

    annual_revenue: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="AnnualRevenue")] = (
        pydantic.Field(default=None)
    )
    """
    Annual revenue
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
