# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .salesforce_account import SalesforceAccount
from .salesforce_campaign import SalesforceCampaign
from .salesforce_case import SalesforceCase
from .salesforce_contact import SalesforceContact
from .salesforce_lead import SalesforceLead
from .salesforce_opportunity import SalesforceOpportunity


class SalesforceData(UniversalBaseModel):
    """
    Complete Salesforce sandbox data structure with all supported objects
    """

    accounts: typing.Optional[typing.List[SalesforceAccount]] = pydantic.Field(default=None)
    """
    List of Salesforce accounts
    """

    contacts: typing.Optional[typing.List[SalesforceContact]] = pydantic.Field(default=None)
    """
    List of Salesforce contacts
    """

    opportunities: typing.Optional[typing.List[SalesforceOpportunity]] = pydantic.Field(default=None)
    """
    List of Salesforce opportunities
    """

    leads: typing.Optional[typing.List[SalesforceLead]] = pydantic.Field(default=None)
    """
    List of Salesforce leads
    """

    cases: typing.Optional[typing.List[SalesforceCase]] = pydantic.Field(default=None)
    """
    List of Salesforce cases
    """

    campaigns: typing.Optional[typing.List[SalesforceCampaign]] = pydantic.Field(default=None)
    """
    List of Salesforce campaigns
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
