# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class SalesforceContact(UniversalBaseModel):
    """
    Salesforce Contact object with comprehensive field support
    """

    first_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="FirstName")] = pydantic.Field(
        default=None
    )
    """
    First name
    """

    last_name: typing_extensions.Annotated[str, FieldMetadata(alias="LastName")] = pydantic.Field()
    """
    Last name (required)
    """

    email: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Email")] = pydantic.Field(
        default=None
    )
    """
    Email address
    """

    phone: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Phone")] = pydantic.Field(
        default=None
    )
    """
    Phone number
    """

    mobile_phone: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="MobilePhone")] = (
        pydantic.Field(default=None)
    )
    """
    Mobile phone number
    """

    title: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Title")] = pydantic.Field(
        default=None
    )
    """
    Job title
    """

    department: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Department")] = pydantic.Field(
        default=None
    )
    """
    Department
    """

    account_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="AccountId")] = pydantic.Field(
        default=None
    )
    """
    Related account ID (18-char Salesforce ID)
    """

    mailing_street: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="MailingStreet")] = (
        pydantic.Field(default=None)
    )
    """
    Mailing street address
    """

    mailing_city: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="MailingCity")] = (
        pydantic.Field(default=None)
    )
    """
    Mailing city
    """

    mailing_state: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="MailingState")] = (
        pydantic.Field(default=None)
    )
    """
    Mailing state/province
    """

    mailing_postal_code: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="MailingPostalCode")] = (
        pydantic.Field(default=None)
    )
    """
    Mailing postal code
    """

    mailing_country: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="MailingCountry")] = (
        pydantic.Field(default=None)
    )
    """
    Mailing country
    """

    description: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Description")] = pydantic.Field(
        default=None
    )
    """
    Contact description
    """

    lead_source: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="LeadSource")] = pydantic.Field(
        default=None
    )
    """
    Lead source (e.g., Web, Phone Inquiry, Partner Referral)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
