# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class SalesforceCase(UniversalBaseModel):
    """
    Salesforce Case object with comprehensive field support
    """

    subject: typing_extensions.Annotated[str, FieldMetadata(alias="Subject")] = pydantic.Field()
    """
    Case subject (required)
    """

    status: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Status")] = pydantic.Field(
        default=None
    )
    """
    Case status (e.g., New, Working, Closed)
    """

    priority: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Priority")] = pydantic.Field(
        default=None
    )
    """
    Priority (e.g., High, Medium, Low)
    """

    origin: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Origin")] = pydantic.Field(
        default=None
    )
    """
    Case origin (e.g., Phone, Email, Web)
    """

    type: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Type")] = pydantic.Field(default=None)
    """
    Case type (e.g., Problem, Question, Feature Request)
    """

    reason: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Reason")] = pydantic.Field(
        default=None
    )
    """
    Case reason
    """

    account_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="AccountId")] = pydantic.Field(
        default=None
    )
    """
    Related account ID (18-char Salesforce ID)
    """

    contact_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="ContactId")] = pydantic.Field(
        default=None
    )
    """
    Related contact ID (18-char Salesforce ID)
    """

    description: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Description")] = pydantic.Field(
        default=None
    )
    """
    Case description
    """

    supplied_email: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="SuppliedEmail")] = (
        pydantic.Field(default=None)
    )
    """
    Supplied email address
    """

    supplied_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="SuppliedName")] = (
        pydantic.Field(default=None)
    )
    """
    Supplied name
    """

    supplied_phone: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="SuppliedPhone")] = (
        pydantic.Field(default=None)
    )
    """
    Supplied phone number
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
