# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class SalesforceCampaign(UniversalBaseModel):
    """
    Salesforce Campaign object
    """

    name: typing_extensions.Annotated[str, FieldMetadata(alias="Name")] = pydantic.Field()
    """
    Campaign name (required)
    """

    type: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Type")] = pydantic.Field(default=None)
    """
    Campaign type (e.g., Email, Webinar, Conference)
    """

    status: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Status")] = pydantic.Field(
        default=None
    )
    """
    Campaign status (e.g., Planned, In Progress, Completed)
    """

    start_date: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="StartDate")] = pydantic.Field(
        default=None
    )
    """
    Start date (format: YYYY-MM-DD)
    """

    end_date: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="EndDate")] = pydantic.Field(
        default=None
    )
    """
    End date (format: YYYY-MM-DD)
    """

    expected_revenue: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="ExpectedRevenue")] = (
        pydantic.Field(default=None)
    )
    """
    Expected revenue
    """

    budgeted_cost: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="BudgetedCost")] = (
        pydantic.Field(default=None)
    )
    """
    Budgeted cost
    """

    actual_cost: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="ActualCost")] = (
        pydantic.Field(default=None)
    )
    """
    Actual cost
    """

    description: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Description")] = pydantic.Field(
        default=None
    )
    """
    Campaign description
    """

    is_active: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="IsActive")] = pydantic.Field(
        default=None
    )
    """
    Is campaign active
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
