# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class SalesforceAccount(UniversalBaseModel):
    """
    Salesforce Account object with comprehensive field support
    """

    name: typing_extensions.Annotated[str, FieldMetadata(alias="Name")] = pydantic.Field()
    """
    Account name (required)
    """

    industry: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Industry")] = pydantic.Field(
        default=None
    )
    """
    Industry (e.g., Technology, Healthcare, Finance)
    """

    type: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Type")] = pydantic.Field(default=None)
    """
    Account type (e.g., Customer, Prospect, Partner)
    """

    phone: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Phone")] = pydantic.Field(
        default=None
    )
    """
    Phone number
    """

    website: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Website")] = pydantic.Field(
        default=None
    )
    """
    Website URL
    """

    annual_revenue: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="AnnualRevenue")] = (
        pydantic.Field(default=None)
    )
    """
    Annual revenue
    """

    number_of_employees: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="NumberOfEmployees")] = (
        pydantic.Field(default=None)
    )
    """
    Number of employees
    """

    billing_street: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="BillingStreet")] = (
        pydantic.Field(default=None)
    )
    """
    Billing street address
    """

    billing_city: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="BillingCity")] = (
        pydantic.Field(default=None)
    )
    """
    Billing city
    """

    billing_state: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="BillingState")] = (
        pydantic.Field(default=None)
    )
    """
    Billing state/province
    """

    billing_postal_code: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="BillingPostalCode")] = (
        pydantic.Field(default=None)
    )
    """
    Billing postal code
    """

    billing_country: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="BillingCountry")] = (
        pydantic.Field(default=None)
    )
    """
    Billing country
    """

    description: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Description")] = pydantic.Field(
        default=None
    )
    """
    Account description
    """

    rating: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="Rating")] = pydantic.Field(
        default=None
    )
    """
    Account rating (e.g., Hot, Warm, Cold)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
