# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .resend_broadcast import ResendBroadcast


class ResendSegment(UniversalBaseModel):
    """
    Resend Segment object - parent containing broadcasts that target this segment
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Segment ID (read-only, set by Resend)
    """

    name: str = pydantic.Field()
    """
    Segment name
    """

    created_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Creation timestamp
    """

    broadcasts: typing.Optional[typing.List[ResendBroadcast]] = pydantic.Field(default=None)
    """
    Broadcasts sent to this segment
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
