# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ResendEmail(UniversalBaseModel):
    """
    Resend Email object - standalone transactional email
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Email ID (read-only, set by Resend)
    """

    from_: typing_extensions.Annotated[str, FieldMetadata(alias="from")] = pydantic.Field()
    """
    Sender email address
    """

    to: typing.List[str] = pydantic.Field()
    """
    Recipient email addresses
    """

    subject: str = pydantic.Field()
    """
    Email subject
    """

    html: typing.Optional[str] = pydantic.Field(default=None)
    """
    HTML content of the email
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Plain text content of the email
    """

    reply_to: typing.Optional[str] = pydantic.Field(default=None)
    """
    Reply-to email address
    """

    cc: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    CC email addresses
    """

    bcc: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    BCC email addresses
    """

    tags: typing.Optional[typing.List[typing.Dict[str, str]]] = pydantic.Field(default=None)
    """
    Email tags for categorization
    """

    created_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Creation timestamp
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
