# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ResendBroadcast(UniversalBaseModel):
    """
    Resend Broadcast object - child of Segment, requires parent segment
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Broadcast ID (read-only, set by Resend)
    """

    from_: typing_extensions.Annotated[str, FieldMetadata(alias="from")] = pydantic.Field()
    """
    Sender email with optional display name
    """

    subject: str = pydantic.Field()
    """
    Email subject
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Broadcast name for internal reference
    """

    html: typing.Optional[str] = pydantic.Field(default=None)
    """
    HTML content
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Plain text content
    """

    reply_to: typing.Optional[str] = pydantic.Field(default=None)
    """
    Reply-to email address
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    Broadcast status (draft, sent, etc.)
    """

    created_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Creation timestamp
    """

    scheduled_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Scheduled send timestamp
    """

    sent_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Actual send timestamp
    """

    topic_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Topic ID for scoping
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
