# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .sandbox_status import SandboxStatus


class ReleaseSandboxResponse(UniversalBaseModel):
    """
    Response model for sandbox release (delete)
    """

    sandbox_id: str = pydantic.Field()
    """
    Released sandbox identifier
    """

    status: SandboxStatus = pydantic.Field()
    """
    Current status after release (should be idle)
    """

    message: str = pydantic.Field()
    """
    Release confirmation message
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
