# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class QuickBooksData(UniversalBaseModel):
    """
    Complete QuickBooks sandbox data structure

    Note: For dump operations, accounts/customers/etc. will contain full API response objects
    with additional fields beyond the minimal input schema. This is expected behavior.
    """

    accounts: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(default=None)
    """
    List of accounts (input: minimal, output: full API objects)
    """

    customers: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(
        default=None
    )
    """
    List of customers (input: minimal, output: full API objects)
    """

    vendors: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(default=None)
    """
    List of vendors (input: minimal, output: full API objects)
    """

    invoices: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(default=None)
    """
    List of invoices (input: minimal, output: full API objects)
    """

    payments: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(default=None)
    """
    List of payments (input: minimal, output: full API objects)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
