# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class OutlookMailMessage(UniversalBaseModel):
    """
    Outlook Mail Message object
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Message ID (read-only, set by Outlook)
    """

    subject: str = pydantic.Field()
    """
    Email subject
    """

    body: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Email body with content and contentType
    """

    from_: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="from")
    ] = pydantic.Field(default=None)
    """
    From address with emailAddress object
    """

    to_recipients: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of recipient email addresses
    """

    cc_recipients: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of CC recipient email addresses
    """

    is_read: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the message has been read
    """

    received_date_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    Date and time the message was received
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
