# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class OutlookCalendarEvent(UniversalBaseModel):
    """
    Outlook Calendar Event object
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Event ID (read-only, set by Outlook)
    """

    subject: str = pydantic.Field()
    """
    Event subject/title
    """

    start: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Start time with dateTime and timeZone
    """

    end: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    End time with dateTime and timeZone
    """

    location: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Location object with displayName
    """

    attendees: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of attendee email addresses (e.g., ['user@example.com'])
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
