# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .one_drive_file import OneDriveFile


class OneDriveFolder(UniversalBaseModel):
    """
    OneDrive Folder object
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Folder ID (read-only, set by OneDrive)
    """

    name: str = pydantic.Field()
    """
    Folder name
    """

    folders: typing.Optional[typing.List["OneDriveFolder"]] = pydantic.Field(default=None)
    """
    List of subfolders
    """

    files: typing.Optional[typing.List[OneDriveFile]] = pydantic.Field(default=None)
    """
    List of files in the folder
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(OneDriveFolder)
