# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .notion_block import NotionBlock
from .notion_comment import NotionComment


class NotionPage(UniversalBaseModel):
    """
    Notion Page object.

    Pages can be:
    1. Standalone pages (top-level in workspace)
    2. Items/rows within a database data source

    For pages in databases, properties should match the data source schema.
    """

    title: str = pydantic.Field()
    """
    Page title
    """

    properties: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Page properties (for database pages)
    """

    blocks: typing.Optional[typing.List[NotionBlock]] = pydantic.Field(default=None)
    """
    Content blocks in this page
    """

    comments: typing.Optional[typing.List[NotionComment]] = pydantic.Field(default=None)
    """
    Comments on this page
    """

    data_source_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the data source this page belongs to (for initialization)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
