# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .notion_data_source import NotionDataSource


class NotionDatabase(UniversalBaseModel):
    """
    Notion Database object - container for data sources.

    Databases organize structured data and can contain multiple data sources.
    Each data source represents a table with its own schema.
    """

    title: str = pydantic.Field()
    """
    Database title
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Database description
    """

    icon: typing.Optional[str] = pydantic.Field(default=None)
    """
    Database icon (emoji or external URL)
    """

    data_sources: typing.Optional[typing.List[NotionDataSource]] = pydantic.Field(default=None)
    """
    Data sources within this database
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
