# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .notion_page import NotionPage


class NotionDataSource(UniversalBaseModel):
    """
    Notion Data Source object - represents a table within a database.

    New in API version 2025-09-03:
    - A database can contain multiple data sources
    - Each data source has its own schema (properties)
    - Pages within a data source follow that schema
    """

    name: str = pydantic.Field()
    """
    Data source name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Data source description
    """

    schema_: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="schema")
    ] = pydantic.Field(default=None)
    """
    Schema definition (property types and configurations)
    """

    pages: typing.Optional[typing.List[NotionPage]] = pydantic.Field(default=None)
    """
    Pages (items/rows) in this data source
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
