# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class NotionBlock(UniversalBaseModel):
    """
    Notion Block object - fundamental content unit.

    Blocks can be: paragraph, heading_1, heading_2, heading_3, bulleted_list_item,
    numbered_list_item, to_do, toggle, code, quote, callout, etc.
    """

    type: str = pydantic.Field()
    """
    Block type (paragraph, heading_1, heading_2, etc.)
    """

    content: str = pydantic.Field()
    """
    Block text content
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
