# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class MoneybirdTimeEntry(UniversalBaseModel):
    """
    Moneybird time entry - API format

    Note: During initialization, this will be linked to a project and contact automatically.
    The started_at and ended_at timestamps will be generated based on the hours field.

    Attributes:
        description: Description of work performed
        hours: Number of hours worked
        billable: Whether this time is billable
    """

    description: str = pydantic.Field()
    """
    Description of work performed
    """

    hours: float = pydantic.Field()
    """
    Number of hours worked
    """

    billable: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this time is billable
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
