# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .moneybird_invoice_detail import MoneybirdInvoiceDetail


class MoneybirdSalesInvoice(UniversalBaseModel):
    """
    Moneybird sales invoice - API format

    Note: During initialization, contact_id will be automatically assigned based on
    the contacts created. Invoice dates will be calculated dynamically.

    Attributes:
        reference: Invoice reference number
        currency: Currency code (e.g., 'EUR')
        prices_are_incl_tax: Whether prices include tax
        state: Invoice state (draft, open, paid)
        details: List of invoice line items
    """

    reference: str = pydantic.Field()
    """
    Invoice reference number
    """

    currency: typing.Optional[str] = pydantic.Field(default=None)
    """
    Currency code
    """

    prices_are_incl_tax: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether prices include tax
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    Invoice state (draft, open, paid)
    """

    details: typing.List[MoneybirdInvoiceDetail] = pydantic.Field()
    """
    Invoice line items
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
