# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class MoneybirdProject(UniversalBaseModel):
    """
    Moneybird project for time tracking and invoicing - API format

    Attributes:
        name: Project name
        state: Project state (active, archived)
        budget: Project budget
    """

    name: str = pydantic.Field()
    """
    Project name
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project state (active, archived)
    """

    budget: typing.Optional[float] = pydantic.Field(default=None)
    """
    Project budget
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
