# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class MoneybirdProduct(UniversalBaseModel):
    """
    Moneybird product/service - API format

    Attributes:
        description: Product description
        title: Product title/name
        price: Product price
        currency: Currency code (e.g., 'EUR')
        identifier: Product SKU/identifier
        frequency: Billing frequency (optional, for recurring products)
        frequency_type: Frequency type (e.g., 'month', 'year')
    """

    description: str = pydantic.Field()
    """
    Product description
    """

    title: str = pydantic.Field()
    """
    Product title/name
    """

    price: str = pydantic.Field()
    """
    Product price as string
    """

    currency: str = pydantic.Field()
    """
    Currency code (e.g., 'EUR')
    """

    identifier: str = pydantic.Field()
    """
    Product SKU/identifier
    """

    frequency: typing.Optional[int] = pydantic.Field(default=None)
    """
    Billing frequency
    """

    frequency_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Frequency type (month, year)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
