# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class MoneybirdLedgerAccount(UniversalBaseModel):
    """
    Moneybird ledger account (chart of accounts) - API format

    Attributes:
        rgs_code: Reference Grootboekschema (RGS) code - required for creation
        name: Account name
        account_type: Account type (revenue, expense, etc.)
        account_id: Account identifier (optional, system accounts may not have this)
    """

    rgs_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    RGS code - required for creation, not returned by GET API
    """

    name: str = pydantic.Field()
    """
    Account name
    """

    account_type: str = pydantic.Field()
    """
    Account type (revenue, expense, etc.)
    """

    account_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Account identifier (optional for system accounts)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
