# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .moneybird_contact import MoneybirdContact
from .moneybird_ledger_account import MoneybirdLedgerAccount
from .moneybird_product import MoneybirdProduct
from .moneybird_project import MoneybirdProject
from .moneybird_sales_invoice import MoneybirdSalesInvoice
from .moneybird_time_entry import MoneybirdTimeEntry


class MoneybirdData(UniversalBaseModel):
    """
    Complete Moneybird sandbox data structure - API format

    Note: Objects are created in dependency order:
    1. Ledger accounts (no dependencies)
    2. Contacts (no dependencies)
    3. Products (no dependencies, but needs tax rates from system)
    4. Projects (no dependencies)
    5. Time entries (linked to projects and contacts)
    6. Sales invoices (linked to contacts)
    """

    ledger_accounts: typing.Optional[typing.List[MoneybirdLedgerAccount]] = pydantic.Field(default=None)
    """
    List of ledger accounts to create
    """

    contacts: typing.Optional[typing.List[MoneybirdContact]] = pydantic.Field(default=None)
    """
    List of contacts to create
    """

    products: typing.Optional[typing.List[MoneybirdProduct]] = pydantic.Field(default=None)
    """
    List of products to create
    """

    projects: typing.Optional[typing.List[MoneybirdProject]] = pydantic.Field(default=None)
    """
    List of projects to create
    """

    time_entries: typing.Optional[typing.List[MoneybirdTimeEntry]] = pydantic.Field(default=None)
    """
    List of time entries to create
    """

    sales_invoices: typing.Optional[typing.List[MoneybirdSalesInvoice]] = pydantic.Field(default=None)
    """
    List of sales invoices to create
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
