# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class MoneybirdContact(UniversalBaseModel):
    """
    Moneybird contact (customer/supplier) - API format

    Attributes:
        company_name: Company name (optional, for business contacts)
        firstname: First name (optional, for individual contacts)
        lastname: Last name (optional, for individual contacts)
        phone: Phone number
        address1: Street address
        city: City
        zipcode: Postal code
        country: Country code (e.g., 'NL', 'DE', 'FR')
        sepa_iban: SEPA IBAN for direct debit (optional)
    """

    company_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Company name
    """

    firstname: typing.Optional[str] = pydantic.Field(default=None)
    """
    First name
    """

    lastname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last name
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    Phone number
    """

    address1: typing.Optional[str] = pydantic.Field(default=None)
    """
    Street address
    """

    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    City
    """

    zipcode: typing.Optional[str] = pydantic.Field(default=None)
    """
    Postal code
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    Country code
    """

    sepa_iban: typing.Optional[str] = pydantic.Field(default=None)
    """
    SEPA IBAN
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
