# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .mem0message import Mem0Message


class Mem0Memory(UniversalBaseModel):
    """
    Mem0 Memory object
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Memory ID (read-only, set by Mem0)
    """

    memory: typing.Optional[str] = pydantic.Field(default=None)
    """
    Memory content (returned from API)
    """

    messages: typing.Optional[typing.List[Mem0Message]] = pydantic.Field(default=None)
    """
    Array of message objects representing the content
    """

    agent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Agent ID
    """

    user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    User ID
    """

    app_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    App ID
    """

    run_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Run ID
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional metadata
    """

    includes: typing.Optional[str] = pydantic.Field(default=None)
    """
    String to include specific preferences in the memory
    """

    excludes: typing.Optional[str] = pydantic.Field(default=None)
    """
    String to exclude specific preferences in the memory
    """

    infer: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to infer memories or directly store messages
    """

    output_format: typing.Optional[str] = pydantic.Field(default=None)
    """
    Response format structure (v1.0 or v1.1)
    """

    custom_categories: typing.Optional[typing.List[typing.Dict[str, str]]] = pydantic.Field(default=None)
    """
    List of custom categories with name and description
    """

    custom_instructions: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project-specific guidelines for handling memories
    """

    immutable: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the memory is immutable
    """

    async_mode: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to add memory asynchronously
    """

    timestamp: typing.Optional[int] = pydantic.Field(default=None)
    """
    Unix timestamp of the memory
    """

    expiration_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Expiration date (YYYY-MM-DD)
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    Memory version (v1 deprecated, use v2)
    """

    created_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Creation timestamp
    """

    updated_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last update timestamp
    """

    owner: typing.Optional[str] = pydantic.Field(default=None)
    """
    Memory owner
    """

    organization: typing.Optional[str] = pydantic.Field(default=None)
    """
    Organization
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
