# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .linear_issue import LinearIssue


class LinearProject(UniversalBaseModel):
    """
    Linear Project object
    """

    name: str = pydantic.Field()
    """
    Project name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project description
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project state (planned, started, paused, completed, canceled)
    """

    issues: typing.Optional[typing.List[LinearIssue]] = pydantic.Field(default=None)
    """
    Issues in this project
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
