# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .linear_comment import LinearComment


class LinearIssue(UniversalBaseModel):
    """
    Linear Issue object
    """

    title: str = pydantic.Field()
    """
    Issue title
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Issue description
    """

    priority: typing.Optional[int] = pydantic.Field(default=None)
    """
    Issue priority (0=No priority, 1=Urgent, 2=High, 3=Medium, 4=Low)
    """

    state_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the workflow state (e.g., 'Todo', 'In Progress', 'Done')
    """

    comments: typing.Optional[typing.List[LinearComment]] = pydantic.Field(default=None)
    """
    Comments on this issue
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
