# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .linear_project import LinearProject


class LinearData(UniversalBaseModel):
    """
    Complete Linear sandbox data structure.

    Relational structure for initialization:
    - Projects contain Issues
    - Issues contain Comments
    """

    projects: typing.Optional[typing.List[LinearProject]] = pydantic.Field(default=None)
    """
    List of projects with their issues. At most 50 projects can be included.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
