# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class JiraSprint(UniversalBaseModel):
    """
    Jira Sprint object
    """

    name: str = pydantic.Field()
    """
    Sprint name
    """

    start_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Sprint start date (ISO 8601 format)
    """

    end_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Sprint end date (ISO 8601 format)
    """

    origin_board_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the board this sprint belongs to (for initialization)
    """

    goal: typing.Optional[str] = pydantic.Field(default=None)
    """
    Sprint goal
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    Sprint state (future, active, closed)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
