# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .jira_issue import JiraIssue


class JiraProject(UniversalBaseModel):
    """
    Jira Project object
    """

    key: str = pydantic.Field()
    """
    Project key (e.g., PROJ)
    """

    name: str = pydantic.Field()
    """
    Project name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project description
    """

    project_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project type (software, business, etc.)
    """

    issues: typing.Optional[typing.List[JiraIssue]] = pydantic.Field(default=None)
    """
    Issues in this project
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
