# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .jira_comment import JiraComment


class JiraIssue(UniversalBaseModel):
    """
    Jira Issue object
    """

    summary: str = pydantic.Field()
    """
    Issue summary/title
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Issue description
    """

    issue_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Issue type (Task, Bug, Story, etc.)
    """

    priority: typing.Optional[str] = pydantic.Field(default=None)
    """
    Issue priority (Highest, High, Medium, Low, Lowest)
    """

    sprint_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the sprint this issue belongs to (for initialization)
    """

    comments: typing.Optional[typing.List[JiraComment]] = pydantic.Field(default=None)
    """
    Comments on this issue
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
