# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class JiraBoard(UniversalBaseModel):
    """
    Jira Board object
    """

    name: str = pydantic.Field()
    """
    Board name
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Board type (scrum or kanban)
    """

    project_key: typing.Optional[str] = pydantic.Field(default=None)
    """
    Key of the project this board belongs to (for initialization)
    """

    filter_jql: typing.Optional[str] = pydantic.Field(default=None)
    """
    JQL for the board filter
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
