# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class HubSpotTicket(UniversalBaseModel):
    """
    HubSpot Ticket object.
    Can be associated with: Contacts, Companies.
    """

    subject: str = pydantic.Field()
    """
    Ticket subject
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Ticket content/description
    """

    pipeline: typing.Optional[str] = pydantic.Field(default=None)
    """
    Ticket pipeline
    """

    pipeline_stage: typing.Optional[str] = pydantic.Field(default=None)
    """
    Ticket pipeline stage
    """

    priority: typing.Optional[str] = pydantic.Field(default=None)
    """
    Ticket priority (HIGH, MEDIUM, LOW)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
