# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class HubSpotTask(UniversalBaseModel):
    """
    HubSpot Task object.
    Can be associated with: Contacts, Companies, Deals, Tickets.
    """

    subject: str = pydantic.Field()
    """
    Task subject/title
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    Task body/description
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    Task status (NOT_STARTED, IN_PROGRESS, COMPLETED, WAITING, DEFERRED)
    """

    priority: typing.Optional[str] = pydantic.Field(default=None)
    """
    Task priority (HIGH, MEDIUM, LOW)
    """

    due_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Task due date (ISO 8601 format)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
