# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class HubSpotDeal(UniversalBaseModel):
    """
    HubSpot Deal object.
    Can be associated with: Contacts, Companies.
    """

    deal_name: str = pydantic.Field()
    """
    Deal name
    """

    amount: typing.Optional[str] = pydantic.Field(default=None)
    """
    Deal amount
    """

    deal_stage: typing.Optional[str] = pydantic.Field(default=None)
    """
    Deal stage
    """

    pipeline: typing.Optional[str] = pydantic.Field(default=None)
    """
    Deal pipeline
    """

    close_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Expected close date
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
